#include <iostream>
#include <string>
#include <algorithm>
#include <map>
#include <set>
#include <list>
#include <vector>
using namespace std;

int a[1000000];
bool mark[1000000] = {};

struct graph {

	int n;
	list<int>* adj;

	graph(int n) {
		this->n = n+1;
		adj = new list<int>[n+1];
	}

	void add_edge(int n,int e) {
		adj[n].push_back(e);
		adj[e].push_back(n);
	}

	void bfs(int s) {

		bool seen[100000] = {};
		list<int> q;

		seen[s] = 1;
		mark[s] = true;
		q.push_back(s);

		while (!q.empty()) {
			s = q.front();
			q.pop_front();
			//cout << s << endl;
			bool m = 0;
			
			for (int x : adj[s]) {
				if (mark[x]) m = 1;
				if (seen[x]) continue;

				seen[x] = 1;
				q.push_front(x);
			}
			if (!m) mark[s] = 1;
		}

		for (int i = 1; i < n; i++) {
			cout << i << ": " << mark[i] << endl;
		}
	}

	bool safe(int node) {
		int s = 0;
		for (int x : adj[node]) {
			if (mark[x]) s++;
		}
		return s;
	}

	void solve1(int s) {
		for (int i = 1; i < n; i++) {
			s = i;
			if (mark[s]) {

				vector<int> t;
				int sum = 0;
				for (int x : adj[s]) {
					
					if (safe(x) == 1) {
						sum += a[x];
						t.push_back(x);

					}
				}
				
				cout << "*\n";
				cout << s << endl;
				cout << sum << endl;
				


				if (sum < a[s]) {
					mark[s] = 0;
					for (int x : t) {
						mark[x] = 1;
						cout << x << endl;
					}
				}

				cout << "*\n";

			}
		}

		for (int i = 1; i < n; i++) {
			cout << i << ": " << mark[i] << endl;
		}
	}

};


int main() {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);

	int n;
	cin >> n;
	
	for (int i = 1; i < n+1; i++) {
		cin >> a[i];
	}
	//graph g(n);

	int x, y;
	for (int i = 0; i < n - 1; i++) {
		cin >> x >> y;
		//g.add_edge(x, y);
	}
	
	int s = 0;
	for (int i = 2; i <= n; i++)
		s += a[i];

	if (a[1]>s) {
		cout << s << endl;
		cout << 0 << endl;
		cout << n - 1 << endl;
		for (int i = 2; i <= n; i++) {
			cout << i << ' ';
		}cout << endl;
	}
	else {
		cout << a[1] << endl;
		cout << 0 << endl;
		cout << 1 << endl;
		cout << 1 << endl;
	}

	//system("pause");
}